/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.hardware.Unknown;
import DE.siemens.ad.logo.util.DataExchange;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.StateMachine;
import DE.siemens.ad.pdraw.simulation.OnlineTestInterpreter;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class OnlineTestProtocolHandler {
    private List fRequestedBlocks = new Vector();
    private List fWatchedBlocks = new Vector();
    private DataTransfer fDataTransfer;
    private WiringDiagram fWD = null;
    protected DataExchange fDataExchange;
    private StateMachine fStateMachine;

    protected void requestNewProgramLines() throws TransmissionFailedException {
        int[] programLines = new int[this.fRequestedBlocks.size()];
        Iterator i = this.fRequestedBlocks.iterator();
        int index = 0;
        while (i.hasNext()) {
            Block block = (Block)i.next();
            programLines[index++] = block.getNumber() - 1 + 10;
        }
        this.fDataTransfer.sendProgramLineRequest(programLines);
        this.fWatchedBlocks = this.fRequestedBlocks;
    }

    public OnlineTestProtocolHandler(DataExchange dataExchange) {
        this.fDataExchange = dataExchange;
    }

    public void run() {
        this.fStateMachine.start();
    }

    public DataTransfer getDataTransfer() {
        return this.fDataTransfer;
    }

    public void setDataTransfer(DataTransfer dataTransfer) {
        this.fDataTransfer = dataTransfer;
    }

    public StateMachine getStateMachine() {
        if (this.fStateMachine == null) {
            NotConnected notConnected = new NotConnected();
            WrongHardware wrongHardware = new WrongHardware();
            Terminated terminated = new Terminated();
            ConnectedNotTestingStop connectedNotTestingStop = new ConnectedNotTestingStop();
            ConnectedNotTestingRunning connectedNotTestingRunning = new ConnectedNotTestingRunning();
            ConnectedTesting connectedTesting = new ConnectedTesting();
            WrongProgram wrongProgram = new WrongProgram();
            CommunicationError communicationError = new CommunicationError();
            DeviceStopped deviceStopped = new DeviceStopped();
            DeviceTimeout deviceTimeout = new DeviceTimeout();
            OnlineTestInterrupted onlineTestInterrupted = new OnlineTestInterrupted();
            StateMachine.State[] states = new OnlineTestState[]{notConnected, terminated, wrongHardware, connectedNotTestingRunning, connectedNotTestingStop, connectedTesting, wrongProgram, communicationError, deviceStopped, deviceTimeout, onlineTestInterrupted};
            ArrayList<Terminated> finalStates = new ArrayList<Terminated>();
            finalStates.add(terminated);
            this.fStateMachine = new StateMachine("OnlineTestProtocolHandler", states, notConnected, finalStates, true);
            this.fStateMachine.setInputHandler(new OnlineTestInputHandler());
        }
        return this.fStateMachine;
    }

    public void setRequestedBlocks(List requestedBlocks) {
        this.fRequestedBlocks = new Vector(requestedBlocks);
        if (this.getStateMachine().getCurrentState() == this.getStateMachine().getState(ConnectedTesting.class)) {
            this.getStateMachine().addInput("requestProgramLines");
        }
    }

    public void setWiringDiagram(WiringDiagram wd) {
        this.fWD = wd;
    }

    public class WrongProgram
    extends OnlineTestState {
        public StateMachine.State terminate() {
            return this.getState(Terminated.class);
        }

        public StateMachine.State emptyInput() {
            return this.getState(Terminated.class);
        }
    }

    public class ConnectedTesting
    extends OnlineTestState {
        private boolean sendEndSimulation() throws TransmissionFailedException {
            return OnlineTestProtocolHandler.this.fDataTransfer.sendStateCommand(20);
        }

        public StateMachine.State stopTest() {
            StateMachine.State nextState = null;
            try {
                this.sendEndSimulation();
                nextState = this.getState(ConnectedNotTestingRunning.class);
            }
            catch (TransmissionFailedException transmissionFailedException) {
                nextState = this.getState(CommunicationError.class);
            }
            return nextState;
        }

        public StateMachine.State stopDevice() {
            StateMachine.State nextState = null;
            try {
                OnlineTestProtocolHandler.this.fDataTransfer.sendStateCommand(18);
                nextState = this.getState(ConnectedNotTestingStop.class);
            }
            catch (TransmissionFailedException transmissionFailedException) {
                nextState = this.getState(CommunicationError.class);
            }
            return nextState;
        }

        public StateMachine.State requestProgramLines() {
            StateMachine.State nextState = null;
            try {
                OnlineTestProtocolHandler.this.fDataTransfer.readSimulationTelegram(false, new int[1]);
                OnlineTestProtocolHandler.this.requestNewProgramLines();
                nextState = this.getState(ConnectedTesting.class);
            }
            catch (TransmissionFailedException transmissionFailedException) {
                if (transmissionFailedException.getError() == 7) {
                    System.out.println("ERROR+++ Ger\u00e4t meldete Simulationsfehler 0x07 w\u00e4hrend der von Bl\u00f6cken Anforderung im Online-Test.");
                }
                nextState = this.getState(OnlineTestInterrupted.class);
            }
            return nextState;
        }

        public StateMachine.State emptyInput() {
            StateMachine.State nextState = null;
            try {
                int[] commandType = new int[1];
                int[] buffer = OnlineTestProtocolHandler.this.fDataTransfer.readSimulationTelegram(true, commandType);
                int deviceChecksum = buffer[0] & 0xFF;
                if ((deviceChecksum += (buffer[1] & 0xFF) << 8) == OnlineTestProtocolHandler.this.fWD.getOldChecksum()) {
                    boolean localChanged;
                    boolean remoteChanged = commandType[0] == 26;
                    boolean bl = localChanged = OnlineTestProtocolHandler.this.fWD.getChangedBlocks().size() > 0;
                    if (localChanged || remoteChanged) {
                        nextState = this.syncParams(remoteChanged, buffer) ? this : this.getState(WrongProgram.class);
                    } else {
                        OnlineTestInterpreter.OnlineTestTelegramBuffer telegram = new OnlineTestInterpreter.OnlineTestTelegramBuffer(buffer, OnlineTestProtocolHandler.this.fWatchedBlocks);
                        OnlineTestProtocolHandler.this.fDataExchange.putData(telegram);
                        nextState = this;
                    }
                } else {
                    nextState = this.getState(WrongProgram.class);
                }
            }
            catch (TransmissionFailedException transmissionFailedException) {
                nextState = this.getState(OnlineTestInterrupted.class);
            }
            return nextState;
        }

        private boolean syncParams(boolean remoteChanged, int[] buffer) {
            boolean ret = false;
            if (remoteChanged) {
                ret = OnlineTestProtocolHandler.this.fWD.handleRemoteChangedBlocks(buffer);
                OnlineTestProtocolHandler.this.fDataTransfer.confirmRemoteParamChange();
                if (ret) {
                    OnlineTestTool.setDrawingModified();
                    Log.println(Language.getString("dialog.onlinetest.bmToLscSynSucceddfully", "Block parameter changes successfully synchronized from the Base Module to LOGO!Soft Comfort."));
                } else {
                    Log.println(Language.getString("dialog.onlinetest.bmToLscSynFailed", "Failed to synchronize block parameter changes from the Base Module to LOGO!Soft Comfort."));
                }
            } else if (OnlineTestProtocolHandler.this.fWD.getChangedBlocks().size() > 0) {
                if (OnlineTestProtocolHandler.this.fDataTransfer.sendParamChangeRequest(OnlineTestProtocolHandler.this.fWD.getParamChangeCommandBytes())) {
                    Log.println(Language.getString("dialog.onlinetest.lscToBMSynSucceddfully", "User program changes successfully synchronized from LOGO!Soft Comfort to the Base Module."));
                    ret = true;
                } else {
                    for (Memory memory : OnlineTestProtocolHandler.this.fWD.getOldMemory()) {
                        OnlineTestProtocolHandler.this.fWD.handleChangedBlock(memory.asArray(), 0, memory.size());
                    }
                    ret = true;
                    Log.println(Language.getString("dialog.onlinetest.lscToBMSynFailed", "Failed to synchronize user program changes from LOGO!Soft Comfort to the Base Module. The changes in LOGO!Soft Comfort will be undone."));
                }
                OnlineTestProtocolHandler.this.fWD.setOldChecksum(((Logo)OnlineTestProtocolHandler.this.fWD.getHardware()).getChecksum(OnlineTestProtocolHandler.this.fWD));
                OnlineTestProtocolHandler.this.fWD.getChangedBlocks().clear();
                OnlineTestProtocolHandler.this.fWD.getOldMemory().clear();
            }
            return ret;
        }

        public StateMachine.State terminate() {
            try {
                this.sendEndSimulation();
            }
            catch (TransmissionFailedException transmissionFailedException) {
                // empty catch block
            }
            return super.terminate();
        }
    }

    public class OnlineTestInterrupted
    extends OnlineTestState {
        public StateMachine.State requestProgramLines() {
            return this.emptyInput();
        }

        public StateMachine.State emptyInput() {
            StateMachine.State nextState = null;
            try {
                this.sleep(200L);
                OnlineTestProtocolHandler.this.fDataTransfer.reset();
                int state = OnlineTestProtocolHandler.this.fDataTransfer.getDeviceState();
                nextState = state == 1 || state == 32 || state == 4 ? this.getState(DeviceTimeout.class) : this.getState(DeviceStopped.class);
            }
            catch (TransmissionFailedException transmissionFailedException) {
                new Thread(){

                    public void run() {
                        super.run();
                        new LogoError(Language.getString("error.com.transmissionFailed", "Transmission failed.")).display();
                    }
                }.start();
                nextState = this.getState(CommunicationError.class);
            }
            return nextState;
        }
    }

    public class DeviceStopped
    extends OnlineTestState {
        public StateMachine.State emptyInput() {
            return this.getState(ConnectedNotTestingStop.class);
        }
    }

    public class DeviceTimeout
    extends OnlineTestState {
        public StateMachine.State emptyInput() {
            StateMachine.State nextState = null;
            try {
                OnlineTestProtocolHandler.this.requestNewProgramLines();
                nextState = this.getState(ConnectedTesting.class);
            }
            catch (TransmissionFailedException transmissionFailedException) {
                nextState = this.getState(CommunicationError.class);
            }
            return nextState;
        }
    }

    public class ConnectedNotTestingRunning
    extends OnlineTestState {
        public StateMachine.State terminate() {
            return this.getState(Terminated.class);
        }

        public StateMachine.State requestProgramLines() {
            StateMachine.State nextState = null;
            try {
                OnlineTestProtocolHandler.this.requestNewProgramLines();
                nextState = this.getState(ConnectedTesting.class);
            }
            catch (TransmissionFailedException transmissionFailedException) {
                if (transmissionFailedException.getError() == 7) {
                    System.out.println("ERROR+++ Ger\u00e4t meldete Simulationsfehler 0x07 w\u00e4hrend der von Bl\u00f6cken Anforderung im Online-Test.");
                }
                nextState = this.getState(CommunicationError.class);
            }
            return nextState;
        }

        public StateMachine.State startTest() {
            StateMachine.State nextState = null;
            try {
                OnlineTestProtocolHandler.this.requestNewProgramLines();
                nextState = this.getState(ConnectedTesting.class);
            }
            catch (TransmissionFailedException transmissionFailedException) {
                nextState = this.getState(CommunicationError.class);
            }
            return nextState;
        }

        public StateMachine.State stopDevice() {
            StateMachine.State nextState = null;
            try {
                OnlineTestProtocolHandler.this.fDataTransfer.sendStateCommand(18);
                nextState = this.getState(ConnectedNotTestingStop.class);
            }
            catch (TransmissionFailedException transmissionFailedException) {
                nextState = this.getState(CommunicationError.class);
            }
            return nextState;
        }

        public StateMachine.State emptyInput() {
            StateMachine.State nextState = null;
            try {
                int state = OnlineTestProtocolHandler.this.fDataTransfer.getDeviceState();
                if (state != 1 && state != 32 && state != 16 && state != 4) {
                    nextState = this.getState(ConnectedNotTestingStop.class);
                } else {
                    this.sleep(500L);
                    nextState = this;
                }
            }
            catch (TransmissionFailedException transmissionFailedException) {
                nextState = this.getState(CommunicationError.class);
            }
            return nextState;
        }
    }

    public class ConnectedNotTestingStop
    extends OnlineTestState {
        public StateMachine.State emptyInput() {
            StateMachine.State nextState = null;
            try {
                int state = OnlineTestProtocolHandler.this.fDataTransfer.getDeviceState();
                if (state == 1 || state == 32 || state == 4) {
                    nextState = this.getState(ConnectedNotTestingRunning.class);
                } else {
                    this.sleep(500L);
                    nextState = this;
                }
            }
            catch (TransmissionFailedException transmissionFailedException) {
                nextState = this.getState(CommunicationError.class);
            }
            return nextState;
        }

        public StateMachine.State startDevice() {
            StateMachine.State nextState = null;
            try {
                OnlineTestProtocolHandler.this.fDataTransfer.sendStateCommand(24);
                this.sleep(1500L);
                if (this.checkStarted()) {
                    OnlineTestProtocolHandler.this.fDataTransfer.getDeviceState();
                }
                nextState = this.getState(ConnectedNotTestingRunning.class);
            }
            catch (TransmissionFailedException transmissionFailedException) {
                nextState = this.getState(CommunicationError.class);
            }
            return nextState;
        }

        public StateMachine.State startTest() {
            StateMachine.State nextState = null;
            try {
                System.out.println("Shift device to run state.");
                OnlineTestProtocolHandler.this.fDataTransfer.sendStateCommand(24);
            }
            catch (TransmissionFailedException transmissionFailedException) {
                nextState = this.getState(CommunicationError.class);
                return nextState;
            }
            this.sleep(1500L);
            this.checkStarted();
            try {
                System.out.println("requestNewProgramLines after see started.");
                OnlineTestProtocolHandler.this.requestNewProgramLines();
                nextState = this.getState(ConnectedTesting.class);
            }
            catch (TransmissionFailedException transmissionFailedException) {
                nextState = this.getState(CommunicationError.class);
                return nextState;
            }
            return nextState;
        }

        public StateMachine.State requestProgramLines() {
            StateMachine.State nextState = null;
            try {
                OnlineTestProtocolHandler.this.fDataTransfer.sendStateCommand(24);
                this.sleep(1500L);
                OnlineTestProtocolHandler.this.requestNewProgramLines();
                nextState = this.getState(ConnectedTesting.class);
            }
            catch (TransmissionFailedException transmissionFailedException) {
                nextState = this.getState(CommunicationError.class);
            }
            return nextState;
        }

        private boolean checkStarted() {
            int i;
            for (i = 0; i < 4; ++i) {
                try {
                    System.out.println("testing device state during waiting device start.");
                    OnlineTestProtocolHandler.this.fDataTransfer.getDeviceState();
                    break;
                }
                catch (TransmissionFailedException e) {
                    System.out.println("Exception cause by device starting.");
                    continue;
                }
            }
            return i < 4;
        }
    }

    public class WrongHardware
    extends OnlineTestState {
        public StateMachine.State emptyInput() {
            return this.getState(Terminated.class);
        }
    }

    public class CommunicationError
    extends OnlineTestState {
        public StateMachine.State emptyInput() {
            return this.getState(NotConnected.class);
        }

        public StateMachine.State terminate() {
            return this.getState(Terminated.class);
        }
    }

    public class NotConnected
    extends OnlineTestState {
        public StateMachine.State emptyInput() {
            try {
                OnlineTestProtocolHandler.this.fDataTransfer.reConnect();
            }
            catch (ExceptionAlreadyHandledException e) {
                return this;
            }
            Hardware hardware = OnlineTestProtocolHandler.this.fDataTransfer.getHardware();
            if (hardware == null || hardware instanceof Unknown) {
                this.sleep(2000L);
                return this;
            }
            if (!hardware.supports("onlineTest")) {
                return this.getState(WrongHardware.class);
            }
            return this.getState(ConnectedNotTestingStop.class);
        }

        public StateMachine.State terminate() {
            return this.getState(Terminated.class);
        }
    }

    public class Terminated
    extends OnlineTestState {
    }

    public static abstract class OnlineTestState
    extends StateMachine.State {
        public StateMachine.State terminate() {
            return this.getState(Terminated.class);
        }

        public StateMachine.State startDevice() {
            return this;
        }

        public StateMachine.State stopDevice() {
            return this;
        }

        public StateMachine.State startTest() {
            return this;
        }

        public StateMachine.State stopTest() {
            return this;
        }

        public StateMachine.State emptyInput() {
            return this;
        }

        public StateMachine.State requestProgramLines() {
            return this;
        }
    }

    public class OnlineTestInputHandler
    extends StateMachine.InputHandler {
        public static final String REQUEST_PROGRAM_LINES = "requestProgramLines";
        public static final String TERMINATE = "terminate";
        public static final String START_DEVICE = "startDevice";
        public static final String STOP_DEVICE = "stopDevice";
        public static final String START_TEST = "startTest";
        public static final String STOP_TEST = "stopTest";

        public StateMachine.State handleInput(Object input, StateMachine.State currentState) {
            OnlineTestState state = (OnlineTestState)currentState;
            StateMachine.State nextState = null;
            if (input == REQUEST_PROGRAM_LINES) {
                nextState = state.requestProgramLines();
            }
            if (input == TERMINATE) {
                nextState = state.terminate();
            }
            if (input == START_DEVICE) {
                nextState = state.startDevice();
            }
            if (input == STOP_DEVICE) {
                nextState = state.stopDevice();
            }
            if (input == START_TEST) {
                nextState = state.startTest();
            }
            if (input == STOP_TEST) {
                nextState = state.stopTest();
            }
            if (input == null) {
                nextState = state.emptyInput();
            }
            if (nextState == null) {
                throw new IllegalArgumentException("The input '" + input + "' was not handled by the input handler +'" + this + "' of the state machine " + currentState.getStateMachine().getName());
            }
            return nextState;
        }

        public Object[] getInputSymbols() {
            return new Object[]{REQUEST_PROGRAM_LINES, TERMINATE, START_DEVICE, STOP_DEVICE, START_TEST, STOP_TEST};
        }
    }
}

